close('all')
clear all
wlen=100;
minutes=20;
fs=1000;
totalpoints=1000*60*minutes;
allemg=[];
alleog=[];
allhs=[];
figure
set(gcf,'doublebuffer','on')
subplot(711)
P1=plot(zeros(wlen,1));
axis([0 wlen -1 1]), grid('on')
subplot(712)
P2=plot(zeros(wlen,1));
axis([0 wlen -1 1]), grid('on')
subplot(713)
P6=plot(zeros(wlen,1));
set(gca,'xlim',[0 10000]), grid('on')
subplot(714)
P3=plot(zeros(wlen,1));
axis([0 wlen -1 1]), grid('on')
subplot(715)
P4=plot(zeros(wlen,1));
axis([0 wlen -1 1]), grid('on')
subplot(716)
P5=plot(zeros(wlen,1));
set(gca,'xlim',[0 10000]), grid('on')
subplot(717)
P7=plot(zeros(wlen,1));
set(gca,'xlim',[0 10000]), grid('on')

AI = analoginput('nidaq',1);
chanI = addchannel(AI,[1 2 4 5 6]);
set(AI, 'SampleRate', fs);
ActualRate = get(AI, 'SampleRate');
set(AI, 'SamplesPerTrigger', totalpoints);
set(AI, 'TriggerType', 'Manual');
start(AI);
trigger(AI);
for i=1:totalpoints/wlen;
    allsig=getdata(AI,wlen);
    emg1=allsig(:,1);
    emg2=allsig(:,2);
    eog1=allsig(:,3);
    eog2=allsig(:,4);
    hs=allsig(:,5);
    emg1=emg1-mean(emg1);
    emg2=emg2-mean(emg2);
    eog1=eog1-mean(eog1);
    eog2=eog2-mean(eog2);
    allemg=[allemg emg1'];
    alleog=[alleog eog1'];
    hs=hs-mean(hs);
    allhs=[allhs hs'];
    set(P1,'ydata',emg1);
    set(P2,'ydata',emg2);
    set(P3,'ydata',eog1);
    set(P4,'ydata',eog2);
    if i>100
        j=(i-100)*wlen;
        k=j+10000;
        set(P5,'ydata',alleog(j:k));
    else
        set(P5,'ydata',alleog);
    end
    if i>100
        j=(i-100)*wlen;
        k=j+10000;
        set(P6,'ydata',allemg(j:k));
    else
        set(P6,'ydata',allemg);
    end
    if i>100
        j=(i-100)*wlen;
        k=j+10000;
        set(P7,'ydata',allhs(j:k));
    else
        set(P7,'ydata',allhs);
    end
    drawnow
    outemg1=sum(prod([emg1';emg1']));
    outemg2=sum(prod([emg2';emg2']));
    outeog1=sum(prod([eog1';eog1']));
    outeog2=sum(prod([eog2';eog2']));

    send=SendOSCMessage('10.104.11.60',6000,'/emg1',outemg1);
    send=SendOSCMessage('10.104.11.60',6000,'/emg2',outemg2);
    send=SendOSCMessage('10.104.11.42',8800,'/eog1',outeog1);
    send=SendOSCMessage('10.104.11.42',8800,'/eog2',outeog2);
   % send=SendOSCMessage('10.104.11.42',8800,'/hsn',hs);

end
delete(AI)
clear AI

